/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity.util.dragon;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityAmphithere;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityIceDragon;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.util.IafMath;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.class_8;

public class IafDragonFlightManager {
    private final EntityDragonBase dragon;
    private class_243 target;
    private class_243 startAttackVec;
    private class_243 startPreyVec;
    private class_1309 prevAttackTarget = null;

    public IafDragonFlightManager(EntityDragonBase dragon) {
        this.dragon = dragon;
    }

    public static float approach(float number, float max, float min) {
        min = Math.abs(min);
        return number < max ? class_3532.method_15363((float)(number + min), (float)number, (float)max) : class_3532.method_15363((float)(number - min), (float)max, (float)number);
    }

    public static float approachDegrees(float number, float max, float min) {
        float add = class_3532.method_15393((float)(max - number));
        return IafDragonFlightManager.approach(number, number + add, min);
    }

    public static float degreesDifferenceAbs(float f1, float f2) {
        return Math.abs(class_3532.method_15393((float)(f2 - f1)));
    }

    public void update() {
        if (this.dragon.method_5968() != null && this.dragon.method_5968().method_5805()) {
            if (this.dragon instanceof EntityIceDragon && this.dragon.method_5799()) {
                this.dragon.airAttack = this.dragon.method_5968() == null ? IafDragonAttacks.Air.SCORCH_STREAM : IafDragonAttacks.Air.TACKLE;
            }
            class_1309 entity = this.dragon.method_5968();
            if (this.dragon.airAttack == IafDragonAttacks.Air.TACKLE) {
                this.target = new class_243(entity.method_23317(), entity.method_23318() + (double)entity.method_17682(), entity.method_23321());
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.HOVER_BLAST) {
                float distY = 5 + this.dragon.getDragonStage() * 2;
                int randomDist = 20;
                if (this.dragon.method_5649(entity.method_23317(), this.dragon.method_23318(), entity.method_23321()) < 16.0 || this.dragon.method_5649(entity.method_23317(), this.dragon.method_23318(), entity.method_23321()) > 900.0) {
                    this.target = new class_243(entity.method_23317() + (double)this.dragon.method_6051().method_43048(randomDist) - (double)randomDist / 2.0, entity.method_23318() + (double)distY, entity.method_23321() + (double)this.dragon.method_6051().method_43048(randomDist) - (double)randomDist / 2.0);
                }
                this.dragon.stimulateFire(entity.method_23317(), entity.method_23318(), entity.method_23321(), 3);
            }
            if (this.dragon.airAttack == IafDragonAttacks.Air.SCORCH_STREAM && this.startPreyVec != null && this.startAttackVec != null) {
                float distX = (float)(this.startPreyVec.field_1352 - this.startAttackVec.field_1352);
                float distY = 5 + this.dragon.getDragonStage() * 2;
                float distZ = (float)(this.startPreyVec.field_1350 - this.startAttackVec.field_1350);
                this.target = new class_243(entity.method_23317() + (double)distX, entity.method_23318() + (double)distY, entity.method_23321() + (double)distZ);
                this.dragon.tryScorchTarget();
                if (this.target != null && this.dragon.method_5649(this.target.field_1352, this.target.field_1351, this.target.field_1350) < 100.0) {
                    this.target = new class_243(entity.method_23317() - (double)distX, entity.method_23318() + (double)distY, entity.method_23321() - (double)distZ);
                }
            }
        } else if (this.target == null || this.dragon.method_5649(this.target.field_1352, this.target.field_1351, this.target.field_1350) < 4.0 || !this.dragon.method_37908().method_22347(class_2338.method_49637((double)this.target.field_1352, (double)this.target.field_1351, (double)this.target.field_1350)) && (this.dragon.isHovering() || this.dragon.isFlying()) || this.dragon.getCommand() == 2 && this.dragon.shouldTPtoOwner()) {
            class_2338 viewBlock = null;
            if (this.dragon instanceof EntityIceDragon && this.dragon.method_5799()) {
                viewBlock = DragonUtils.getWaterBlockInView(this.dragon);
            }
            if (this.dragon.getCommand() == 2 && this.dragon.useFlyingPathFinder()) {
                viewBlock = this.dragon instanceof EntityIceDragon && this.dragon.method_5799() ? DragonUtils.getWaterBlockInViewEscort(this.dragon) : DragonUtils.getBlockInViewEscort(this.dragon);
            } else if (this.dragon.lookingForRoostAIFlag) {
                class_2338 upPos = this.dragon.method_18412();
                if (this.dragon.getDistanceSquared(class_243.method_24953((class_2382)this.dragon.method_18412())) > 200.0f) {
                    upPos = upPos.method_10086(30);
                }
                viewBlock = upPos;
            } else if (viewBlock == null) {
                viewBlock = DragonUtils.getBlockInView(this.dragon);
                if (this.dragon.method_5799()) {
                    this.dragon.setHovering(true);
                }
            }
            if (viewBlock != null) {
                this.target = new class_243((double)viewBlock.method_10263() + 0.5, (double)viewBlock.method_10264() + 0.5, (double)viewBlock.method_10260() + 0.5);
            }
        }
        if (this.target != null) {
            if (this.target.field_1351 > (double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue()) {
                this.target = new class_243(this.target.field_1352, (double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue(), this.target.field_1350);
            }
            if (this.target.field_1351 >= this.dragon.method_23318() && !this.dragon.isModelDead()) {
                this.dragon.method_18799(this.dragon.method_18798().method_1031(0.0, 0.1, 0.0));
            }
        }
    }

    public class_243 getFlightTarget() {
        return this.target == null ? class_243.field_1353 : this.target;
    }

    public void setFlightTarget(class_243 target) {
        this.target = target;
    }

    private float getDistanceXZ(double x, double z) {
        float f = (float)(this.dragon.method_23317() - x);
        float f2 = (float)(this.dragon.method_23321() - z);
        return f * f + f2 * f2;
    }

    public void onSetAttackTarget(class_1309 LivingEntityIn) {
        if (this.prevAttackTarget != LivingEntityIn) {
            this.startPreyVec = LivingEntityIn != null ? new class_243(LivingEntityIn.method_23317(), LivingEntityIn.method_23318(), LivingEntityIn.method_23321()) : new class_243(this.dragon.method_23317(), this.dragon.method_23318(), this.dragon.method_23321());
            this.startAttackVec = new class_243(this.dragon.method_23317(), this.dragon.method_23318(), this.dragon.method_23321());
        }
        this.prevAttackTarget = LivingEntityIn;
    }

    public static class PlayerFlightMoveHelper<T extends class_1308>
    extends class_1335 {
        private final T dragon;

        public PlayerFlightMoveHelper(T dragon) {
            super(dragon);
            this.dragon = dragon;
        }

        public void method_6240() {
            EntityDragonBase theDragon;
            T t = this.dragon;
            if (t instanceof EntityDragonBase && (theDragon = (EntityDragonBase)t).method_5642() != null) {
                return;
            }
            double flySpeed = this.field_6372 * this.speedMod() * 3.0;
            class_243 dragonVec = this.dragon.method_19538();
            class_243 moveVec = new class_243(this.field_6370, this.field_6369, this.field_6367);
            class_243 normalized = moveVec.method_1020(dragonVec).method_1029();
            double dist = dragonVec.method_1022(moveVec);
            this.dragon.method_18800(normalized.field_1352 * flySpeed, normalized.field_1351 * flySpeed, normalized.field_1350 * flySpeed);
            if (dist > 2.5E-7) {
                float yaw = (float)Math.toDegrees(Math.PI * 2 - Math.atan2(normalized.field_1352, normalized.field_1351));
                this.dragon.method_36456(this.method_6238(this.dragon.method_36454(), yaw, 5.0f));
                this.dragon.method_6125((float)this.field_6372);
            }
            this.dragon.method_5784(class_1313.field_6308, this.dragon.method_18798());
        }

        public double speedMod() {
            return (this.dragon instanceof EntityAmphithere ? 0.6 : 1.25) * (double)((Double)IafCommonConfig.INSTANCE.dragon.dragonFlightSpeedMod.getValue()).floatValue() * this.dragon.method_26825(class_5134.field_23719);
        }
    }

    public static class FlightMoveHelper
    extends class_1335 {
        private final EntityDragonBase dragon;

        public FlightMoveHelper(EntityDragonBase dragonBase) {
            super((class_1308)dragonBase);
            this.dragon = dragonBase;
        }

        public void method_6240() {
            if (this.dragon.field_5976) {
                this.dragon.method_36456(this.dragon.method_36454() + 180.0f);
                this.field_6372 = 0.1f;
                this.dragon.flightManager.target = null;
                return;
            }
            float distX = (float)(this.dragon.flightManager.getFlightTarget().field_1352 - this.dragon.method_23317());
            float distY = (float)(this.dragon.flightManager.getFlightTarget().field_1351 - this.dragon.method_23318());
            float distZ = (float)(this.dragon.flightManager.getFlightTarget().field_1350 - this.dragon.method_23321());
            double planeDist = Math.sqrt(distX * distX + distZ * distZ);
            double yDistMod = 1.0 - (double)class_3532.method_15379((float)(distY * 0.7f)) / planeDist;
            distX = (float)((double)distX * yDistMod);
            distZ = (float)((double)distZ * yDistMod);
            planeDist = class_3532.method_15355((float)(distX * distX + distZ * distZ));
            double dist = Math.sqrt(distX * distX + distZ * distZ + distY * distY);
            if (dist > 1.0) {
                float yawCopy = this.dragon.method_36454();
                float atan = (float)class_3532.method_15349((double)distZ, (double)distX);
                float yawTurn = class_3532.method_15393((float)(this.dragon.method_36454() + 90.0f));
                float yawTurnAtan = class_3532.method_15393((float)(atan * 57.295776f));
                this.dragon.method_36456(IafDragonFlightManager.approachDegrees(yawTurn, yawTurnAtan, this.dragon.airAttack == IafDragonAttacks.Air.TACKLE && this.dragon.method_5968() != null ? 10.0f : 4.0f) - 90.0f);
                this.dragon.field_6283 = this.dragon.method_36454();
                if (IafDragonFlightManager.degreesDifferenceAbs(yawCopy, this.dragon.method_36454()) < 3.0f) {
                    this.field_6372 = IafDragonFlightManager.approach((float)this.field_6372, 1.8f, 0.005f * (1.8f / (float)this.field_6372));
                } else {
                    this.field_6372 = IafDragonFlightManager.approach((float)this.field_6372, 0.2f, 0.025f);
                    if (dist < 100.0 && this.dragon.method_5968() != null) {
                        this.field_6372 *= dist / 100.0;
                    }
                }
                float finPitch = (float)(-(class_3532.method_15349((double)(-distY), (double)planeDist) * 57.2957763671875));
                this.dragon.method_36457(finPitch);
                float yawTurnHead = this.dragon.method_36454() + 90.0f;
                this.field_6372 *= this.dragon.getFlightSpeedModifier();
                this.field_6372 *= Math.min(1.0, dist / 50.0 + 0.3);
                double x = this.field_6372 * (double)class_3532.method_15362((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distX / dist);
                double y = this.field_6372 * (double)class_3532.method_15374((float)(finPitch * ((float)Math.PI / 180))) * Math.abs((double)distY / dist);
                double z = this.field_6372 * (double)class_3532.method_15374((float)(yawTurnHead * ((float)Math.PI / 180))) * Math.abs((double)distZ / dist);
                double motionCap = 0.2;
                this.dragon.method_18799(this.dragon.method_18798().method_1031(Math.min(x * 0.2, motionCap), Math.min(y * 0.2, motionCap), Math.min(z * 0.2, motionCap)));
            }
        }
    }

    public static class GroundMoveHelper
    extends class_1335 {
        public GroundMoveHelper(class_1308 LivingEntityIn) {
            super(LivingEntityIn);
        }

        public float distance(float rotateAngleFrom, float rotateAngleTo) {
            return (float)IafMath.atan2_accurate(class_3532.method_15374((float)(rotateAngleTo - rotateAngleFrom)), class_3532.method_15362((float)(rotateAngleTo - rotateAngleFrom)));
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6376) {
                class_8 nodeprocessor;
                float f = (float)this.field_6371.method_5996(class_5134.field_23719).method_6194();
                float f1 = (float)this.field_6372 * f;
                float f2 = this.field_6368;
                float f3 = this.field_6373;
                float f4 = class_3532.method_15355((float)(f2 * f2 + f3 * f3));
                if (f4 < 1.0f) {
                    f4 = 1.0f;
                }
                f4 = f1 / f4;
                float f5 = class_3532.method_15374((float)(this.field_6371.method_36454() * ((float)Math.PI / 180)));
                float f6 = class_3532.method_15362((float)(this.field_6371.method_36454() * ((float)Math.PI / 180)));
                float f7 = (f2 *= f4) * f6 - (f3 *= f4) * f5;
                float f8 = f3 * f6 + f2 * f5;
                class_1408 pathnavigate = this.field_6371.method_5942();
                if (pathnavigate != null && (nodeprocessor = pathnavigate.method_6342()) != null && nodeprocessor.method_17((class_1922)this.field_6371.method_37908(), class_3532.method_15357((double)(this.field_6371.method_23317() + (double)f7)), class_3532.method_15357((double)this.field_6371.method_23318()), class_3532.method_15357((double)(this.field_6371.method_23321() + (double)f8))) != class_7.field_12) {
                    this.field_6368 = 1.0f;
                    this.field_6373 = 0.0f;
                    f1 = f;
                }
                this.field_6371.method_6125(f1);
                this.field_6371.method_5930(this.field_6368);
                this.field_6371.method_5938(this.field_6373);
                this.field_6374 = class_1335.class_1336.field_6377;
            } else if (this.field_6374 == class_1335.class_1336.field_6378) {
                this.field_6374 = class_1335.class_1336.field_6377;
                EntityDragonBase dragonBase = (EntityDragonBase)this.field_6371;
                double d0 = this.method_6236() - this.field_6371.method_23317();
                double d1 = this.method_6237() - this.field_6371.method_23321();
                double d2 = this.method_6235() - this.field_6371.method_23318();
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                if (d3 < 2.500000277905201E-7) {
                    this.field_6371.method_5930(0.0f);
                    return;
                }
                float targetDegree = (float)(class_3532.method_15349((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                float changeRange = 70.0f;
                if (Math.ceil(dragonBase.method_17681()) > 2.0) {
                    float ageMod = 1.0f - (float)Math.min(dragonBase.getAgeInDays(), 125) / 125.0f;
                    changeRange = 5.0f + ageMod * 10.0f;
                }
                this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), targetDegree, changeRange));
                this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                if (d2 > (double)this.field_6371.method_49476() && d0 * d0 + d1 * d1 < (double)Math.max(1.0f, this.field_6371.method_17681() / 2.0f)) {
                    this.field_6371.method_5993().method_6233();
                    this.field_6374 = class_1335.class_1336.field_6379;
                }
            } else if (this.field_6374 == class_1335.class_1336.field_6379) {
                this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                if (this.field_6371.method_24828()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                }
            } else {
                this.field_6371.method_5930(0.0f);
            }
        }
    }
}

